package gov.va.genisis2.model;

import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * The Class RoleType.
 * 
 * Description: In this RoleType Class implements the interface Serializable and
 * defines the entity and data mapping for the dbo.Role_Type Table in the
 * database.
 * 
 */
@Entity
@Table(name = "Role_Type", schema = "dbo")
public class RoleType implements java.io.Serializable {

	/**
	 * serialVersionUID field for serializable class
	 */
	private static final long serialVersionUID = 5498231117527242153L;

	/** The role type id. */
	private int roleTypeId;

	/** The role name. */
	private String roleName;

	/** The role description. */
	private String roleDescription;

	/** The user role types. */
	private Set<UserRoleType> userRoleTypes = new HashSet<>(0);

	/**
	 * Instantiates a new role type.
	 */
	public RoleType() {
		// Do nothing. The method is an intentionally-blank override.
	}

	/**
	 * Instantiates a new role type.
	 *
	 * @param roleTypeId the role type id
	 * @param roleName the role name
	 * @param roleDescription the role description
	 */
	public RoleType(int roleTypeId, String roleName, String roleDescription) {
		this.roleTypeId = roleTypeId;
		this.roleName = roleName;
		this.roleDescription = roleDescription;
	}

	/**
	 * Instantiates a new role type.
	 *
	 * @param roleTypeId the role type id
	 * @param roleName the role name
	 * @param roleDescription the role description
	 * @param userRoleTypes the user role types
	 */
	public RoleType(int roleTypeId, String roleName, String roleDescription, Set<UserRoleType> userRoleTypes) {
		this.roleTypeId = roleTypeId;
		this.roleName = roleName;
		this.roleDescription = roleDescription;
		this.userRoleTypes = userRoleTypes;
	}

	/**
	 * Gets the role type id.
	 *
	 * @return the role type id
	 */
	@Id
	@Column(name = "Role_Type_id", unique = true, nullable = false)
	public int getRoleTypeId() {
		return this.roleTypeId;
	}

	/**
	 * Sets the role type id.
	 *
	 * @param roleTypeId the new role type id
	 */
	public void setRoleTypeId(int roleTypeId) {
		this.roleTypeId = roleTypeId;
	}

	/**
	 * Gets the role name.
	 *
	 * @return the role name
	 */
	@Column(name = "Role_Name", length = 50, nullable = false)
	public String getRoleName() {
		return this.roleName;
	}

	/**
	 * Sets the role name.
	 *
	 * @param roleName the new role name
	 */
	public void setRoleName(String roleName) {
		this.roleName = roleName;
	}

	/**
	 * Gets the role description.
	 *
	 * @return the role description
	 */
	@Column(name = "Role_Description", length = 50, nullable = false)
	public String getRoleDescription() {
		return this.roleDescription;
	}

	/**
	 * Sets the role description.
	 *
	 * @param roleDescription the new role description
	 */
	public void setRoleDescription(String roleDescription) {
		this.roleDescription = roleDescription;
	}

	/**
	 * Gets the user role types.
	 *
	 * @return the user role types
	 */
	@OneToMany(fetch = FetchType.LAZY, mappedBy = "roleType")
	public Set<UserRoleType> getUserRoleTypes() {
		return this.userRoleTypes;
	}

	/**
	 * Sets the user role types.
	 *
	 * @param userRoleTypes the new user role types
	 */
	public void setUserRoleTypes(Set<UserRoleType> userRoleTypes) {
		this.userRoleTypes = userRoleTypes;
	}

}
